% Machine Learning class - Learning Algorithms and Systems
% Laboratory, EPFL, Lecturer A. Billard
% Demo Code and Images by Basilio Noris, 2010
%
% Original ICA Code by David Gleich, 2003
% http://www.stanford.edu/~dgleich/projects/pca_neural_nets_website/

close all;
clear all;

%% Load images
saveSteps = false;
f1 = rgb2gray(imread('01.jpg'));
f2 = rgb2gray(imread('02.jpg'));

res = [150 200];
f1 = imresize(f1, res, 'bicubic');
f2 = imresize(f2, res, 'bicubic');

%% mix images

rand('seed', 2);

[m n] = size(f1);

s1 = im2double(reshape(f1, 1, m*n));
s2 = im2double(reshape(f2, 1, m*n));

figure(1);

s1m = mean(s1);
s2m = mean(s2);
s1nm = s1 - s1m;
s2nm = s2 - s2m;

S = [s1; s2];
Snm = [s1nm; s2nm];

M = rand(2,2);


X = M*S;

x1 = (mat2gray(reshape(X(1,:), m, n))-min(X(1,:)))*255/(max(X(1,:))-min(X(1,:)));
x2 = (mat2gray(reshape(X(2,:), m, n))-min(X(2,:)))*255/(max(X(2,:))-min(X(2,:)));

if(saveSteps)
    filename = 'mix-source.png';
    imwrite([f1 f2], filename, 'png');

    filename = 'img-iter0.png';
    imwrite([x1./255 x2./255], filename, 'png');
end
figure(1);clf; hold on;
subplot(2,1,1); hold on;
title('Sources S1, S2');
montage([f1, f2]);
subplot(2,1,2); hold on;
title('Mixtures x1, x2');
montage([x1./255 x2./255]);

%% run ica
iterations = 1;
for i=1:iterations
    if(i==1)
        B = easi(X,2,res,'niter',1, 'saveSteps', saveSteps);
    else
        B = easi(X,2,res,'niter',1, 'B', B, 'saveSteps', saveSteps);
    end
    Y = B*X;
    e1 = mat2gray(reshape(Y(1,:), m, n));
    e2 = mat2gray(reshape(Y(2,:), m, n));

    e1 = (e1-min(e1(:)))* 255./(max(e1(:))-min(e1(:)));
    e2 = (e2-min(e2(:)))* 255./(max(e2(:))-min(e2(:)));

    figure(2);clf;
    montage([e1./255 e2./255]); title('Mixtures x1, x2');

    drawnow;
    %if(saveSteps)
    %filename = sprintf('img-iter%d.png',i);
    %imwrite([e1./255 e2./255], filename, 'png');
    %end
end


%% all in one batch
% return;

Beasi = easi(X, 2, res, 'niter', 7, 'saveSteps', saveSteps);
Yeasi = Beasi*X;
e1 = mat2gray(reshape(Yeasi(1,:), m, n));
e2 = mat2gray(reshape(Yeasi(2,:), m, n));

e1 = (e1-min(e1(:)))* 255./(max(e1(:))-min(e1(:)));
e2 = (e2-min(e2(:)))* 255./(max(e2(:))-min(e2(:)));

figure(2);clf;
montage([f1 f2; e1 e2]);
title('Reconstructed Sources s1, s2');

